package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiAlbumImageDto;

import java.util.List;

/**
 * 音乐相册 图片记录 Remote
 *
 * @author lifuquan
 */
@AdvancedFeignClient
public interface RemoteAlbumImageService {

    /**
     * 创建音乐相册 图片记录
     *
     * @param albumImageDtos
     * @return
     */
    List<Long> create(List<YoutuiAlbumImageDto> albumImageDtos);

    /**
     * 根据ids更新图片状态
     *
     * @param ids
     * @return
     */
    int modifyStatusByIds(List<Long> ids);

    /**
     * 根据ids逻辑删除
     *
     * @param ids
     * @return
     */
    int removeByIds(List<Long> ids);

    /**
     * 根据相册id逻辑删除
     *
     * @param albumId
     * @return
     */
    int removeByAlbumId(Long albumId);

    /**
     * 根据相册id查询图片
     *
     * @param albumId
     * @return
     */
    List<YoutuiAlbumImageDto> getList(Long albumId);

    /**
     * 根据相册id查询 未经检测的图片
     *
     * @param albumId
     * @return
     */
    List<YoutuiAlbumImageDto> getNeedCheckList(Long albumId);
}
