package cn.com.duiba.tuia.youtui.center.api.dto.rsp;

import cn.com.duiba.tuia.youtui.center.api.dto.youtui.WechatPutConfigDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiHotAirticleDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 内容分享信息
 * Created by xuefeng on 2018/5/19.
 */
@ApiModel("分享结果对象")
public class ContentShareRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 分享url **/
    @ApiModelProperty(value = "分享url ",dataType = "String")
    private String shareUrl;

    @ApiModelProperty(value = "分享短链接",dataType = "String")
    private String shortShareUrl;

    /** 微信分享图片 **/
    @ApiModelProperty(value = "微信分享图片",dataType = "String")
    private String wxShareImg;

    /** 微信分享title */
    @ApiModelProperty(value = "微信分享title",dataType = "String")
    private String wxShareTitle;

    /** 微信分享文案 **/
    @ApiModelProperty(value = "微信分享文案",dataType = "String")
    private String wxShareInfo;

    /** 内容类型 **/
    @ApiModelProperty(value = "内容类型",dataType = "Integer")
    private Integer contentType;

    /** 内容id **/
    @ApiModelProperty(value = "内容id",dataType = "Long")
    private Long contentId;

    @ApiModelProperty(value = "是否需要参与(0:不需要；1：需要)",dataType = "String")
    private Integer shareJoin;

    @ApiModelProperty(value = "二维码坐标对象", dataType = "QRCodePoint")
    private WechatPutConfigDto.QRCodePoint qRCodePoint;

    /** 预览url **/
    @ApiModelProperty(value = "预览URL",dataType = "String")
    private String previewUrl;

    /** 微信分享快照图片. */
    @ApiModelProperty(value = "微信分享快照图片",dataType = "String")
    private String wxSnapshotImg;

    /** 微信分享快照图片. */
    @ApiModelProperty(value = "分享内容（1：图文；2：图片）", dataType = "Integer")
    private Integer shareContentType;

    @ApiModelProperty(value = "分享文案编号", dataType = "Integer")
    private int shareContentIndex;

    @ApiModelProperty(value = "文章默认评论集合")
    private List<YoutuiHotAirticleDto.DefaultComment> defaultComments;

    @ApiModelProperty(value = "我的专栏文章数量")
    private Integer hotTextCount;

    @ApiModelProperty(value = "我的专栏文章阅读量")
    private Integer hotTextReads;

    public String getShortShareUrl() {
        return shortShareUrl;
    }

    public void setShortShareUrl(String shortShareUrl) {
        this.shortShareUrl = shortShareUrl;
    }

    public Integer getHotTextCount() {
        return hotTextCount;
    }

    public void setHotTextCount(Integer hotTextCount) {
        this.hotTextCount = hotTextCount;
    }

    public Integer getHotTextReads() {
        return hotTextReads;
    }

    public void setHotTextReads(Integer hotTextReads) {
        this.hotTextReads = hotTextReads;
    }

    public List<YoutuiHotAirticleDto.DefaultComment> getDefaultComments() {
        return defaultComments;
    }

    public void setDefaultComments(List<YoutuiHotAirticleDto.DefaultComment> defaultComments) {
        this.defaultComments = defaultComments;
    }

    public int getShareContentIndex() {
        return shareContentIndex;
    }

    public void setShareContentIndex(int shareContentIndex) {
        this.shareContentIndex = shareContentIndex;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getShareContentType() {
        return shareContentType;
    }

    public void setShareContentType(Integer shareContentType) {
        this.shareContentType = shareContentType;
    }

    public String getWxSnapshotImg() {
        return wxSnapshotImg;
    }

    public void setWxSnapshotImg(String wxSnapshotImg) {
        this.wxSnapshotImg = wxSnapshotImg;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public WechatPutConfigDto.QRCodePoint getqRCodePoint() {
        return qRCodePoint;
    }

    public void setqRCodePoint(WechatPutConfigDto.QRCodePoint qRCodePoint) {
        this.qRCodePoint = qRCodePoint;
    }

    public Integer getShareJoin() {
        return shareJoin;
    }

    public void setShareJoin(Integer shareJoin) {
        this.shareJoin = shareJoin;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getWxShareImg() {
        return wxShareImg;
    }

    public void setWxShareImg(String wxShareImg) {
        this.wxShareImg = wxShareImg;
    }

    public String getWxShareTitle() {
        return wxShareTitle;
    }

    public void setWxShareTitle(String wxShareTitle) {
        this.wxShareTitle = wxShareTitle;
    }

    public String getWxShareInfo() {
        return wxShareInfo;
    }

    public void setWxShareInfo(String wxShareInfo) {
        this.wxShareInfo = wxShareInfo;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

}
