package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiAnswerQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiAnswerDto;

/**
 * Create by yuanwei
 * at 2018/8/31 0031 下午 16:39
 */
@AdvancedFeignClient
public interface RemoteYoutuiAnswerService {

    /**
     * 获取答题模板数据
     * @param query
     * @return
     */
    PageDto<YoutuiAnswerDto> selectByParams(YoutuiAnswerQuery query);

    /**
     * 获取答题模板通过id
     * @param id
     * @return
     */
    YoutuiAnswerDto selectById(Long id);

    /**
     * 保存答题模板
     * @param dto
     * @return
     */
    Long saveYoutuiAnswerDto(YoutuiAnswerDto dto);

    /**
     * 通过id删除
     * @param id
     * @return
     */
    int deleteById(Long id);

}
