package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDThemeDto;

import java.util.List;

/**
 * 拼多多主题活动
 */
@AdvancedFeignClient
public interface RemoteYoutuiPddThemeService {

    /**
     * 插入拼多多主题活动
     * @param list
     * @return
     */
    int insert(List<PDDThemeDto.Theme> list);

    /**
     * 删除拼多多活动
     * @param ids 要删除的主题ID
     * @return
     */
    int delete(List<Long> ids);

    /**
     * 删除全部的拼多多的主题活动
     * @return
     */
    int deleteAll();

    /**
     * 查询前6调主题
     * @return
     */
    List<PDDThemeDto.Theme> selectSixOrderById();

    /**
     * 查询特定的主题列表
     * @param ids
     * @return
     */
    List<PDDThemeDto.Theme> selectByIds(List<Long> ids);

    /**
     * 删除重新插入
     * @return
     */
    Integer deleteAndInsert(List<PDDThemeDto.Theme> list);
}
