package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/31 0031 下午 16:08
 */
@ApiModel("测试题答题配置")
public class YoutuiTestAnswerConfigDto extends YoutuiBaseAnswerConfigDto{
    @ApiModelProperty(value = "测试类型，0：答题测试，1：随机测试",dataType = "Integer")
    private Integer testType;
    @ApiModelProperty(value = "答题类型，0：得分，1：跳题",dataType = "Integer")
    private Integer questionType;
    @ApiModelProperty(value = "需要条件",dataType = "List<needCondition>")
    private List<NeedCondition> needConditions;

    public Integer getTestType() {
        return testType;
    }

    public void setTestType(Integer testType) {
        this.testType = testType;
    }

    public Integer getQuestionType() {
        return questionType;
    }

    public void setQuestionType(Integer questionType) {
        this.questionType = questionType;
    }

    public List<NeedCondition> getNeedConditions() {
        return needConditions;
    }

    public void setNeedConditions(List<NeedCondition> needConditions) {
        this.needConditions = needConditions;
    }

    @ApiModel("需要条件")
    public static class NeedCondition implements Serializable{

        @ApiModelProperty(value = "条件名",dataType = "String")
        private String label;
        @ApiModelProperty(value = "条件值",dataType = "String")
        private String value;
        @ApiModelProperty(value = "条件类型，1-姓名，2-生日，3-星座，4-生肖")
        private Integer type;

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }
    }
}
