package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 主题活动推广链接信息
 */
public class PDDThemeSponsoredLinksDto {
    /**
     * 主题活动推广链接
     */
    private String url;
    /**
     * 主题活动推广短链
     */
    private String shortUrl;
    /**
     * 主题活动推广移动链接
     */
    private String mobileUrl;
    /**
     * 主题活动推广移动短链接
     */
    private String mobileShortUrl;
    /**
     * 主题活动推广开团链接
     */
    private String multiGroupUrl;
    /**
     * 主题活动推广开团短链接
     */
    private String multiGroupShortUrl;
    /**
     * 主题活动推广开团移动端链接
     */
    private String multiGroupMobileUrl;
    /**
     * 主题活动推广开团移动端短链接
     */
    private String multiGroupMobileShortUrl;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getShortUrl() {
        return shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getMobileUrl() {
        return mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getMobileShortUrl() {
        return mobileShortUrl;
    }

    public void setMobileShortUrl(String mobileShortUrl) {
        this.mobileShortUrl = mobileShortUrl;
    }

    public String getMultiGroupUrl() {
        return multiGroupUrl;
    }

    public void setMultiGroupUrl(String multiGroupUrl) {
        this.multiGroupUrl = multiGroupUrl;
    }

    public String getMultiGroupShortUrl() {
        return multiGroupShortUrl;
    }

    public void setMultiGroupShortUrl(String multiGroupShortUrl) {
        this.multiGroupShortUrl = multiGroupShortUrl;
    }

    public String getMultiGroupMobileUrl() {
        return multiGroupMobileUrl;
    }

    public void setMultiGroupMobileUrl(String multiGroupMobileUrl) {
        this.multiGroupMobileUrl = multiGroupMobileUrl;
    }

    public String getMultiGroupMobileShortUrl() {
        return multiGroupMobileShortUrl;
    }

    public void setMultiGroupMobileShortUrl(String multiGroupMobileShortUrl) {
        this.multiGroupMobileShortUrl = multiGroupMobileShortUrl;
    }

    public static class Req extends PDDBaseReq{
        /**
         * 推广位ID 必填
         */
        private String pid = PDDConstant.PID;
        /**
         * 主题ID列表,例如[1,235] 必填
         */
        private List<Long> themeIdList;
        /**
         * 是否生成短链接,true-是,false-否 非必填
         */
        private Boolean generateShortUrl;
        /**
         * 是否生成手机跳转链接。true-是,false-否,默认false 非必填
         */
        private Boolean generateMobile;
        /**
         * 自定义参数,为链接打上自定义标签。自定义参数最长限制64个字节。 非必填
         */
        private String customParameters;
        /**
         * 是否唤起微信客户端， 默认false 否，true 是 非必填
         */
        private Boolean generateWeappWebview;
        /**
         * 唤起微信app推广短链接 非必填
         */
        private Boolean weAppWebViewShortUrl;
        /**
         * 唤起微信app推广链接 非必填
         */
        private Boolean weAppWebWiewUrl;

        public String getPid() {
            return pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public List<Long> getThemeIdList() {
            return themeIdList;
        }

        public void setThemeIdList(List<Long> themeIdList) {
            this.themeIdList = themeIdList;
        }

        public Boolean getGenerateShortUrl() {
            return generateShortUrl;
        }

        public void setGenerateShortUrl(Boolean generateShortUrl) {
            this.generateShortUrl = generateShortUrl;
        }

        public Boolean getGenerateMobile() {
            return generateMobile;
        }

        public void setGenerateMobile(Boolean generateMobile) {
            this.generateMobile = generateMobile;
        }

        public String getCustomParameters() {
            return customParameters;
        }

        public void setCustomParameters(String customParameters) {
            this.customParameters = customParameters;
        }

        public Boolean getGenerateWeappWebview() {
            return generateWeappWebview;
        }

        public void setGenerateWeappWebview(Boolean generateWeappWebview) {
            this.generateWeappWebview = generateWeappWebview;
        }

        public Boolean getWeAppWebViewShortUrl() {
            return weAppWebViewShortUrl;
        }

        public void setWeAppWebViewShortUrl(Boolean weAppWebViewShortUrl) {
            this.weAppWebViewShortUrl = weAppWebViewShortUrl;
        }

        public Boolean getWeAppWebWiewUrl() {
            return weAppWebWiewUrl;
        }

        public void setWeAppWebWiewUrl(Boolean weAppWebWiewUrl) {
            this.weAppWebWiewUrl = weAppWebWiewUrl;
        }

        public Map<String, String> toMap() {
            Map<String, String> map = super.toMap();
            map.put("pid", this.getPid());
            map.put("theme_id_list", Arrays.toString(this.getThemeIdList().toArray(new Long[0])));
            if (this.getGenerateShortUrl() != null) {
                map.put("generate_short_url", this.getGenerateShortUrl().toString());
            }
            if (this.getGenerateMobile() != null) {
                map.put("generate_mobile", this.getGenerateMobile().toString());
            }
            if (StringUtils.isNotBlank(this.getCustomParameters())) {
                map.put("custom_parameters", this.getCustomParameters());
            }
            if (this.getGenerateWeappWebview() != null) {
                map.put("generate_weapp_webview", this.getGenerateWeappWebview().toString());
            }
            if (this.getWeAppWebViewShortUrl() != null) {
                map.put("we_app_web_view_short_url", this.getWeAppWebViewShortUrl().toString());
            }
            if (this.getWeAppWebWiewUrl() != null) {
                map.put("we_app_web_wiew_url", this.getWeAppWebWiewUrl().toString());
            }
            return map;
        }

        @Override
        public String getType() {
            return "pdd.ddk.theme.prom.url.generate";
        }
    }

    /**
     * 将返回的JSON Object转换为class
     * @return
     */
    public static List<PDDThemeSponsoredLinksDto> jsonObjectToClass(JSONObject jsonObject) {
        JSONObject themePromotionUrlGenerateResponse = jsonObject.getJSONObject("theme_promotion_url_generate_response");
        JSONArray urlList = themePromotionUrlGenerateResponse.getJSONArray("url_list");
        List<PDDThemeSponsoredLinksDto> rspList = new ArrayList<>(urlList.size());
        for (Object url : urlList) {
            JSONObject jsonInfo = (JSONObject) url;
            PDDThemeSponsoredLinksDto rsp = new PDDThemeSponsoredLinksDto();
            rsp.setUrl(jsonInfo.getString("url"));
            rsp.setShortUrl(jsonInfo.getString("short_url"));
            rsp.setMobileUrl(jsonInfo.getString("mobile_url"));
            rsp.setMobileShortUrl(jsonInfo.getString("mobile_short_url"));
            rsp.setMultiGroupUrl(jsonInfo.getString("multi_group_url"));
            rsp.setMultiGroupShortUrl(jsonInfo.getString("multi_group_short_url"));
            rsp.setMultiGroupMobileUrl(jsonInfo.getString("multi_group_mobile_url"));
            rsp.setMultiGroupMobileShortUrl(jsonInfo.getString("multi_group_mobile_short_url"));
            rspList.add(rsp);
        }
        return rspList;
    }

    public static void main(String[] args) throws Exception {
        Req req = new Req();
        List<Long> list = Arrays.asList(1193L,1195L);
        req.setThemeIdList(list);
        JSONObject request = req.request();
        List<PDDThemeSponsoredLinksDto> pddThemeSponsoredLinksDtos = PDDThemeSponsoredLinksDto.jsonObjectToClass(request);
        System.out.println(pddThemeSponsoredLinksDtos);
    }

}
