package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.req.PDDListReq;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.PDDGoodsDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd.YoutuiPddBurstingSkuDto;

import java.util.Date;
import java.util.List;

/**
 * 拼多多商品的service
 *
 * @author lichao 2018/9/12
 */
@AdvancedFeignClient
public interface RemotePDDGoodService {

    /**
     * 通过id查询库里面已经有的id
     *
     * @param ids
     */
    List<Long> selectSkuByIds(List<Long> ids);

    /**
     * 插入sku
     */
    void insertSkus(List<PDDGoodsDto> dtos);

    /**
     * 通过上一次同步时间来进行查询
     *
     * @param date
     * @return
     */
    List<PDDGoodsDto> selectSkuBySynTime(Date date);

    /**
     * 同步数据
     *
     * @param needSynGoods    需要同步数据的商品
     * @param needDeleteGoods 需要删除掉的商品
     */
    void synSkuCoupon(List<PDDGoodsDto> needSynGoods, List<PDDGoodsDto> needDeleteGoods);

    /**
     * 根据类目查询商品列表
     * @param start
     * @param pageSize
     * @param optId
     * @return
     */
    List<PDDGoodsDto> selectSkuByOptId(Integer start, Integer pageSize, Long optId);

    /**
     * 根据类目查询商品列表
     * @return
     */
    List<PDDGoodsDto> selectSkuByParam(PDDListReq req);

    /**
     * 获取七日爆款
     * @return
     */
    List<YoutuiPddBurstingSkuDto> getBurstingGoods();

    /**
     * 通过showDate获取爆款商品
     * @param showDate
     * @return
     */
    YoutuiPddBurstingSkuDto getBurstingGoodByDate(Date showDate);

    /**
     * 删除爆款商品
     * @return
     */
    Boolean deleteBurstingGoods(Date showDate,Long goodId);

    /**
     * 保存爆款商品
     * @return
     */
    Boolean insertOrUpdateBurstingGoods(Date showDate,Long goodId);

    Boolean updateBurstingGoods(Date showDate,List<Long> goodIds);

    /**
     * 获取小于等于查询的日期并且数量大于等于size的
     */
    YoutuiPddBurstingSkuDto selectByDateAndSize(Date showDate,Integer size);
}