package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.push.PushDto;
import cn.com.duiba.tuia.youtui.center.api.dto.push.UrlPushDto;

import java.util.List;

/**
 * 推送
 * @author lichao 2018/8/4
 */
@AdvancedFeignClient
public interface RemotePushService {

    /**
     * 异步推送
     * @param pushDto
     * @param delay 推送延迟时间，单位毫秒
     * @param userId
     */
    void pushSyn(PushDto pushDto, Integer delay, Long... userId);

    /**
     * 同步推送
     */
    void push(PushDto pushDto, Long... userIds);

    /** 推送url */
    void pushUrl(PushDto dto,Integer delay,  UrlPushDto urlPushDto, Long[] userIds);

    /** 推送url */
    void pushUrl2(PushDto dto,Integer delay,  UrlPushDto urlPushDto, List<Long> userIds);
}
