package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiUserGoldAdjustDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiUserManagerDto;

import java.util.List;

/**
 * 用户管理remote业务
 * @author liyuanzeng 2018/8/31
 */
@AdvancedFeignClient
public interface RemoteYoutuiUserGoldAdjustService {

    /**
     * 查询列表
     * @param userId
     * @return
     */
    List<YoutuiUserGoldAdjustDto> selectList(Long userId);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    YoutuiUserGoldAdjustDto selectById(Long id);

    /**
     * 新增
     * @param dto
     * @return
     */
    Long insert(YoutuiUserGoldAdjustDto dto);

    /**
     * 修改
     * @param dto
     * @return
     */
    Long update(YoutuiUserGoldAdjustDto dto);

    /**
     * 删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * ids批量查询
     * @param ids
     * @return
     */
    List<YoutuiUserGoldAdjustDto> selectByIds(List<Long> ids);
}
