/**
 * Project Name:tuia-youtui-web<br>
 * File Name:UserAccount.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model<br>
 * Date:2017年1月22日下午3:33:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.youtui.center.api.dto.consumer;


import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * ClassName: UserAccount <br/>
 * Function: 用户信息. <br/>
 * date: 2017年1月22日 下午3:33:46 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class UserAccountCenter implements Serializable {

    private static final long serialVersionUID = 1L;

    /** The app id. */
    private Long              appId;

    /** The user id. */
    private Long              userId;

    /** The partner user id. */
    private String            partnerUserId;

    /**
     * 用户标志
     */
    private Integer mark;

    /** 创建时间 */
    private Date gmtCreate;

    /** 用户头像 */
    private String image;

    /** 用户昵称 */
    private String nickName;

    /** 当前用户所在的app版本号 */
    private Integer version;

    /**
     * Creates a new instance of UserAccount.
     *
     * @param appId
     * @param partnerUserId
     */

    public UserAccountCenter(Long appId, String partnerUserId) {
        super();
        this.appId = appId;
        this.partnerUserId = partnerUserId;
    }

    /**
     * Creates a new instance of UserAccount.
     */

    public UserAccountCenter() {
        super();
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }


    public Integer getMark() {
        return mark;
    }

    public void setMark(Integer mark) {
        this.mark = mark;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
