package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiSpiderUrlDto;

import java.util.List;

/**
 * 热文爬虫已爬url记录服务
 */
@AdvancedFeignClient
public interface RemoteYoutuiSpiderUrlServer {

    /**
     * 插入一条已爬url
     *
     * @param dto
     * @return
     */
    int insert(YoutuiSpiderUrlDto dto);

    /**
     * 批量插入已爬url
     * @param dto
     * @return
     */
    int batchInsert(List<YoutuiSpiderUrlDto> dto);

    /**
     * 查询url是否爬过
     *
     * @param md5 爬取url的md5
     * @return
     */
    int selectCountByMd5(String md5);

    /**
     * 查询url是否爬过
     *
     * @param md5s 爬取url的md5
     * @return
     */
    List<String> selectInList(List<String> md5s);
}
