package cn.com.duiba.tuia.youtui.center.api.constant;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lifuquan
 */
public enum ContentHealthStatus {

    /**
     * 尚未检测
     */
    UNCHECK("uncheck"),

    /**
     * 图片正常，无需进行其余操作；或者未识别出目标对象
     */
    PASS("pass"),

    /**
     * 检测结果不确定，需要进行人工审核；或者识别出目标对象
     */
    REVIEW("review"),

    /**
     * 图片违规，建议执行进一步操作（如直接删除或做限制处理）
     */
    BLOCK("block"),

    /**
     * 未知
     */
    UNKNOWN("unknown")
    ;

    private String value;

    ContentHealthStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ContentHealthStatus getByValue(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }

        for (ContentHealthStatus status : ContentHealthStatus.values()) {
            if (StringUtils.equals(status.getValue(), value)) {
                return status;
            }
        }

        return null;
    }
}
