package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Create by yuanwei
 * at 2018/8/14 0014 下午 16:55
 */
@ApiModel("热文DTO")
public class YoutuiHotAirticleDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("热文id")
    private Long id;

    @ApiModelProperty("是否删除，0：未删除，1：已删除")
    private Integer isDeleted;

    @ApiModelProperty("热文标题")
    private String title;

    @ApiModelProperty("热文内容")
    private String titleContext;

    @ApiModelProperty("热文标签")
    private String tag;

    @ApiModelProperty("热文来源，0：手工，1:趣闻，2:微小宝")
    private Integer textSource;

    @ApiModelProperty("是否推荐，0：未推荐，1：已推荐")
    private Integer isRecommend;

    @ApiModelProperty("热文url链接")
    private String url;

    @ApiModelProperty("热文默认评论")
    private List<DefaultComment> comments;

    @ApiModelProperty("入库时间")
    private String storageTime;

    @ApiModelProperty("是否发布，0：未发布，1：已发布")
    private Integer isPublish;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("是否可以发布")
    private Integer isRealse;

    @ApiModelProperty("文章阅读数基准值")
    private Integer readCount;

    @ApiModelProperty("文章作者")
    private String author;

    @ApiModelProperty("缩略图url")
    private String thumbnailUrl;

    @ApiModelProperty("是否存在默认缩略图")
    private Integer isHaveDefaultImg;

    @ApiModelProperty("是否显示缩略图")
    private String isShowCardImg;

    @ApiModelProperty("发布时间")
    private String publishTime;

    @ApiModelProperty("添加时间")
    private String editTime;

    @ApiModelProperty("文章状态，0-爬虫热文，1-待上架热文")
    private Integer articleState;

    @ApiModelProperty("运营标签")
    private String oprateTag;


    public Integer getIsHaveDefaultImg() {
        return isHaveDefaultImg;
    }

    public void setIsHaveDefaultImg(Integer isHaveDefaultImg) {
        this.isHaveDefaultImg = isHaveDefaultImg;
    }

    public Integer getReadCount() {
        return readCount;
    }

    public void setReadCount(Integer readCount) {
        this.readCount = readCount;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Integer getIsRealse() {
        return isRealse;
    }

    public void setIsRealse(Integer isRealse) {
        this.isRealse = isRealse;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setTitleContext(String titleContext) {
        this.titleContext = titleContext;
    }

    public String getTitleContext() {
        return titleContext;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return tag;
    }

    public Integer getTextSource() {
        return textSource;
    }

    public void setTextSource(Integer textSource) {
        this.textSource = textSource;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return url;
    }

    public List<DefaultComment> getComments() {
        return comments;
    }

    public void setComments(List<DefaultComment> comments) {
        this.comments = comments;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public String getStorageTime() {
        return storageTime;
    }

    public void setStorageTime(String storageTime) {
        this.storageTime = storageTime;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getIsShowCardImg() {
        return isShowCardImg;
    }

    public void setIsShowCardImg(String isShowCardImg) {
        this.isShowCardImg = isShowCardImg;
    }

    public String getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(String publishTime) {
        this.publishTime = publishTime;
    }

    public String getEditTime() {
        return editTime;
    }

    public void setEditTime(String editTime) {
        this.editTime = editTime;
    }

    public Integer getArticleState() {
        return articleState;
    }

    public void setArticleState(Integer articleState) {
        this.articleState = articleState;
    }

    public String getOprateTag() {
        return oprateTag;
    }

    public void setOprateTag(String oprateTag) {
        this.oprateTag = oprateTag;
    }

    @ApiModel("朋友圈热文默认评论")
    public static class DefaultComment implements Serializable {

        @ApiModelProperty(value = "序号", dataType = "Integer")
        private Integer i;

        @ApiModelProperty(value = "内容", dataType = "String")
        private String c;

        public Integer getI() {
            return i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public String getC() {
            return c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}
