package cn.com.duiba.tuia.youtui.center.api.dto.youtui.pdd;

import org.apache.commons.lang3.StringUtils;

/**
 *
 * 拼多多的所有系统使用的pid
 * @author lichao 2018/10/26
 */
public enum PDDPIDEnum {
    SEARCH("1923191_33491279","趣晒-Android-搜索结果"),
    HOTDAY("1923191_32732331","趣晒-Android-爆款抢购"),
    DOUBLE11("1923191_33465327","趣晒-双11"),
    RECOMMOND("1923191_33416258","趣晒-热文评论区广告位"),
    ANDROID("1923191_32906037","趣晒-Android"),
    TEST("1923191_32896160","测试"),


    ;

    public static PDDPIDEnum getByName(String name){
        if(StringUtils.isNotBlank(name)) {
            for (PDDPIDEnum pddpidEnum : PDDPIDEnum.values()) {
                if (pddpidEnum.name().equalsIgnoreCase(name)){
                    return pddpidEnum;
                }
            }
        }
        return ANDROID;
    }


    PDDPIDEnum(String pid, String name) {
        this.pid = pid;
        this.name = name;
    }

    private String pid;

    private String name;

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
