package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiAlbumQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiAlbumDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiAlbumWithImageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiMakeAlbumDto;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiMakeAlbumResultDto;

/**
 * 音乐相册 制作记录 Remote
 *
 * @author lifuquan
 */
@AdvancedFeignClient
public interface RemoteAlbumService {

    /**
     * 制作音乐相册
     *
     * @param makeAlbumDto
     * @return
     */
    YoutuiMakeAlbumResultDto makeAlbum(YoutuiMakeAlbumDto makeAlbumDto);

    /**
     * 创建音乐相册记录
     *
     * @param albumDto
     * @return
     */
    Long create(YoutuiAlbumDto albumDto);

    /**
     * 根据id逻辑删除
     *
     * @param id
     * @return
     */
    int removeById(Long id);

    /**
     * 根据id逻辑删除 相册和图片
     *
     * @param id
     * @return
     */
    void removeByIdWithImage(Long id);

    /**
     * 根据id查询音乐相册
     *
     * @param id
     * @return
     */
    YoutuiAlbumDto getById(Long id);

    /**
     * 根据id查询音乐相册组装图片集
     *
     * @param id
     * @return
     */
    YoutuiAlbumWithImageDto getByIdWithImage(Long id);

    /**
     * 根据unionId查询相册个数
     *
     * @param unionId
     * @return
     */
    int getListCount(String unionId);

    /**
     * 获取音乐相册 制作记录列表
     *
     * @return
     */
    PageDto<YoutuiAlbumDto> getList(YoutuiAlbumQuery blessingQuery);
}
