package cn.com.duiba.tuia.log.sdk.mybatis.plugin;

import cn.com.duiba.tuia.log.sdk.cache.CacheKey;
import cn.com.duiba.tuia.log.sdk.cache.ThreadLocalCache;
import cn.com.duiba.tuia.log.sdk.sql.SQLHelp;
import cn.com.duiba.tuia.log.sdk.sql.SQLUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年03月21日 09:46
 * @descript:
 * @version: 1.0
 */
@Intercepts({@Signature(args = {MappedStatement.class, Object.class}, method = "update", type = Executor.class)})
public class LogMybatisPlugin implements Interceptor {

    private final Logger logger = LoggerFactory.getLogger(LogMybatisPlugin.class);

    private final int MAPPED_STATEMENT_INDEX = 0;
    private final int PARAMETER_INDEX = 1;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {

        try {

            MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[MAPPED_STATEMENT_INDEX];
            Executor executor = (Executor) invocation.getTarget();

            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[PARAMETER_INDEX];
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            //得到sql语句
            String executeSql = this.getExecuteSql(boundSql.getSql());
            List<Map<String, Object>> resultList = SQLHelp.executeSQL(mappedStatement, executor.getTransaction(), parameter, boundSql, executeSql);
            this.setOrigin(resultList);
        } catch (Exception e) {
            //捕捉异常，不影响业务流程
            logger.error("获取sql语句错误", e);
        }

        Object returnObj = invocation.proceed();

        return returnObj;
    }

    /**
     * 向缓存里设置原始数据的值
     * @param resultList
     */
    private void setOrigin(List<Map<String, Object>> resultList) {

        Object origin = ThreadLocalCache.get(CacheKey.ORIGIN_KEY);
        if (origin == null) {
            ThreadLocalCache.put(CacheKey.ORIGIN_KEY, resultList);
            return;
        }

        ((List<Map<String, Object>>) origin).addAll(resultList);
    }

    /**
     * 获取变更之后的select语句
     * @param sql
     * @return
     */
    private String getExecuteSql(String sql) {

        if (SQLUtils.isUpdateSql(sql)) {
            sql = SQLUtils.getSelectByUpdate(sql);
        }

        if (SQLUtils.isUpdateSql(sql)) {
            sql = SQLUtils.getSelectByUpdate(sql);
        }

        return sql;
    }

    @Override
    public Object plugin(Object target) {
        if (target instanceof Executor)
            return Plugin.wrap(target, this);
        return target;
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
