package cn.com.duiba.tuia.log.sdk.sql;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.transaction.Transaction;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年03月21日 16:17
 * @descript:
 * @version: 1.0
 */
public class SQLHelp {

    public static List<Map<String,Object>> executeSQL(
            final MappedStatement mappedStatement, final Transaction transaction, final Object parameterObject,
            final BoundSql boundSql,final String sql) throws SQLException {

        Connection connection = transaction.getConnection();
        PreparedStatement statement = connection.prepareStatement(sql);
        DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement,parameterObject,boundSql);
        handler.setParameters(statement);

        ResultSet resultSet = statement.executeQuery();
        List<Map<String,Object>> result = new ArrayList();
        while (resultSet.next()) {
            result.add(getResultMap(resultSet));
        }

        return result;
    }


    private static Map<String,Object> getResultMap(ResultSet resultSet) throws SQLException {

        ResultSetMetaData resultSetMD = resultSet.getMetaData();
        Map<String,Object> resultMap = new ConcurrentHashMap<>();
        for (int i=0,len = resultSetMD.getColumnCount();i< len;i++){
            resultMap.put(resultSetMD.getColumnLabel(i),resultSet.getObject(i));
        }

        return resultMap;
    }

}
