/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.log.sdk.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalCache {
    private static final ThreadLocal<Map<Object, Object>> store = new ThreadLocal(){

        protected Map<Object, Object> initialValue() {
            return new ConcurrentHashMap<Object, Object>();
        }
    };

    public static void put(Object key, Object value) {
        store.get().put(key, value);
    }

    public static Object get(Object key) {
        return store.get().get(key);
    }

    public static boolean isKeyExist(Object key) {
        return store.get().containsKey(key);
    }

    public static void clear() {
        store.get().clear();
    }
}

