/**
 * Project Name:tuia-client
 * File Name:RemoteAdvertBackendService.java
 * Package Name:cn.com.tuia.advert.service
 * Date:2016年8月10日下午3:09:50
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.tuia.advert.service;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.tuia.advert.model.ReqFilterAdvertsDto;
import cn.com.tuia.advert.model.ReqFinishBizDto;

/**
 * ClassName:RemoteAdvertBackendService <br/>
 * Function: 该类提供广告后端服务调用. <br/>
 * Reason:	 广告推荐系统调用. <br/>
 * Date:     2016年8月10日 下午3:09:50 <br/>
 * @author   sunjiangrong
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAdvertEngineService {
    
    /**
     * 
     * 检查该活动下当天该用户抽取广告券的次数. <br/>
     *
     * @author sunjiangrong
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> checkActivityLimit(Long consumerId, Long activityId);

    /**
     * 
     * 该方法提供给推荐系统，过滤不符合条件的广告. <br/>
     *
     * @author sunjiangrong
     * @param req
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<Long>> filterAdverts(ReqFilterAdvertsDto req);
    
    /**
     * 
     * 完成广告券投放之后反馈业务订单. <br/>
     *
     * @author sunjiangrong
     * @param req
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> finishBiz(ReqFinishBizDto req);
}

