package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AbnormalMonitoringContentTypeEnum <br/>
 * Function: 广告异常监控-监控内容枚举. <br/>
 * 监控内容：1-失效，2-消耗，3-落地页到达率，4-落地页成本，5-注册成本，6-激活成本，7-APP启动成本
 * date: 2019年3月26日 下午6:54:16 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AbnormalMonitoringContentTypeEnum {
    /** 失效 */
    INVALID(1, "失效"),

    /** 消耗 */
    CONSUME(2, "消耗"),

    /** 落地页到达率 */
    PROMOTE_ARRIVAL_RATE(3, "落地页到达率"),
    
    /** 落地页成本 */
    PROMOTE_COST(4, "落地页成本"),

    /** 注册成本*/
    REGISTE_COST(5, "注册成本"),

    /** 激活成本 */
    ACTIVATE_COST(6, "激活成本"),

    /** APP启动成本 */
    START_COST(7, "APP启动成本"),

    /** APP付费成本 */
    PAY_COST(8, "APP付费成本"),

    /** APP进件成本 */
    ENTRY_COST(9, "APP进件成本"),

    /** APP完件成本 */
    FINISH_COST(10, "APP完件成本"),

    /** APP签收成本 */
    SIGN_COST(11, "APP签收成本");

    private String desc;

    private Integer code;

    AbnormalMonitoringContentTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AbnormalMonitoringContentTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AbnormalMonitoringContentTypeEnum it : AbnormalMonitoringContentTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AbnormalMonitoringContentTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
