package cn.com.tuia.advert.model.SimpleAppAdvertDto;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 美团那边需要的广告配置相关信息
 */
@Data
public class SimpleMeituanAdvertDto implements Serializable {

    private static final long serialVersionUID = 9193940463159821904L;
    /** 广告ID. */
    private Long advertId;

    /** 素材ID. */
    private Long materialId;

    /** 配置ID. */
    private Long adSpecId;

    /** 订单ID. */
    private String orderId;

    /**  日志扩展map */
    private Map<String, Object> logExtMap;

    /**
     * 广告最终出价
     */
    private Double fee;

    /**
     * 点击率
     */
    private Double ctr;

    /**
     * 维稳因子
     */
    private Double roiFactor;

    /**
     * 落地页链接
     */
    private String promoteUrl;

    /**
     * 原始价格
     */
    private Double oriPrice;

    /**
     * groupID-》根据广告计划id 生成
     */
    private String groupId;

    //转换率
    private Double cvr;

    /**
     * ctr * 广告线原始cpc出价
     */
    private Double arpu;

    /**
     * arpu * 分成比例
     */
    private Double oriScore;

    /**
     * ctr * 调整后的adx出价price
     */
    private Double score;

    /**
     * 0---命中白名单，对照组
     * 1---命中白名单，实验组
     * 2---未命中白名单
     */
    private Integer cpcTest;

    /**
     * 计划维度设置的目标分成比例
     */
    private Double advShareRate;

    /**
     * 广告线 发券CPC价格
     */
    private Double advPrice;

    private String      newTradeTagId;    // 广告对应新行业的tag_id

}
