package cn.com.tuia.advert.cache;

import com.alibaba.fastjson.JSON;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lijicong
 * @since 2021-08-02
 */
@Getter
@AllArgsConstructor
public enum RedisKeyEnum implements CacheKeyEnumerable {

    // 新媒体测试
    NMT_BACKFLOW_ADVERTS(RedisCommonKeys.KC154.name(), "新媒体测试-回流广告"),
    NMT_DAY_LAUNCH(RedisCommonKeys.KC154.name() + "_DL", "新媒体测试-广告在新媒体的当日发券"),
    NMT_DAY_LAUNCH_QUIT(RedisCommonKeys.KC154.name() + "_DLQ", "新媒体测试-当日发券量超过最大值的广告"),
    // NMT_QUIT_ADVERTS(RedisCommonKeys.KC154.name() + "_QA", "新媒体测试-退出机制的广告"),

    // 其他
    ;

    private final String key;
    private final String desc;

    @Override
    public String getSpace() {
        return RedisCommonKeys.APPNAME;
    }
}
