package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AbnormalMonitoringTargetTypeEnum <br/>
 * Function: 广告异常监控-监控目标枚举. <br/>
 * date: 2019年3月26日 下午6:54:16 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AbnormalMonitoringTargetTypeEnum {
    /** 广告 */
    ADVERT(1, "广告"),

    /** 配置 */
    ORIENTATION(2, "配置"),

    /** 配置 */
    ORIENT_APP(4, "配置下媒体");

    private String desc;

    private Integer code;

    AbnormalMonitoringTargetTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AbnormalMonitoringTargetTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AbnormalMonitoringTargetTypeEnum it : AbnormalMonitoringTargetTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AbnormalMonitoringTargetTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
