package cn.com.tuia.advert.enums;


/**
 *  活动来源
 */
public enum ActivitySourceEnum {
    /** 兑吧. */
    SOURCE_DUIBA(0,"兑吧"),

    /** 推啊. */
    SOURCE_TUIA(1,"推啊");


    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private ActivitySourceEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static ActivitySourceEnum getByCode(int code){
        for(ActivitySourceEnum enumVal : ActivitySourceEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
