package cn.com.tuia.advert.enums;

import cn.com.tuia.advert.adxService.AdxSceneService;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.HashMap;

public enum AdxSetSceneType implements AdxSceneService {

    //设置请求时候adx类型
    SET_REQ_ADX_SCENE{
        @Override
        public void setReqScene(ObtainAdvertReq req, String adxSceneType) {
            if (req.getLogExtMap() == null) {
                req.setLogExtMap(new HashMap<>());
            }
            req.getLogExtMap().put("adxScene",adxSceneType);
        }

        @Override
        public void setExposeScene(AdxLogReq req, String adxSceneType) {
        }
    },

    //设置曝光时候ADX 类型
    SET_EXPOSE_ADX_SCENE{
        @Override
        public void setReqScene(ObtainAdvertReq req, String adxSceneType) {

        }

        @Override
        public void setExposeScene(AdxLogReq req, String adxSceneType) {
            if (req.getLogExtMap() == null) {
                req.setLogExtMap(new HashMap<>());
            }
            req.getLogExtMap().put("adxScene",adxSceneType);
        }
    };
}
