package cn.com.tuia.advert.enums;

import lombok.Getter;

import java.util.HashSet;
import java.util.Set;

@Getter
public enum GroupTagEnum {

    ART_PRICE(0, "原人工出价逻辑"),

    ALG_PRICE_STRATEGY(1, "原算法出价策略"),

    ART_PRICE_STRATEGY(2, "原人工出价策略"),

    ALG_PRICE(3, "原算法出价逻辑"),

    ALG_PRICE_STRATEGY_ONE(4,  "算法出价策略1"),

    ALG_PRICE_STRATEGY_TWO(5, "算法出价策略2"),


    ;

    private Integer code;

    private String description;

    private static Set<Integer> opentTestSets = new HashSet<>();

    static {
        opentTestSets.add(ALG_PRICE_STRATEGY.getCode());
        opentTestSets.add(ALG_PRICE.getCode());
        opentTestSets.add(ALG_PRICE_STRATEGY_ONE.getCode());
        opentTestSets.add(ALG_PRICE_STRATEGY_TWO.getCode());
    }

    GroupTagEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    /**
     * 是否开启了实验
     * @param groupId
     * @return
     */
    public static boolean openTest(Integer groupId){

        // 1, 3, 4, 5 开启实验
        return opentTestSets.contains(groupId);
    }
}
