package cn.com.tuia.advert.enums;


/**
 * 投放目标类型
 */
public enum PutTargetTypeEnum {
    //老阈值： 1：消耗优先  2：抢量  3：均衡 4-人工定向
    //新阈值：1-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先
    default_type(0, 1, "默认"),
    stable_put(1, 2, "稳定投放"),
    grab_priority_mid(2, 2, "抢量优先(中)"),
    grab_priority_high(3, 2, "抢量优先(高)"),
    manual_target(4, 3, "人工定向"),
    cost_priority(5, 2, "成本优先");

    //投放目标
    private Integer putTargetType;

    //投放模式（targetAppLimit），1-人工包，2-自动模式，3-优投模式
    private Integer targetAppLimit;

    private String desc;

    PutTargetTypeEnum(Integer putTargetType, Integer targetAppLimit, String desc) {
        this.putTargetType = putTargetType;
        this.targetAppLimit = targetAppLimit;
        this.desc = desc;
    }

    public static Integer getTargetAppLimit(Integer putTargetType) {
        if (putTargetType == null) {
            return 0;
        }
        for (PutTargetTypeEnum typeEnum : values()) {
            if (typeEnum.getPutTargetType().equals(putTargetType)) {
                return typeEnum.getTargetAppLimit();
            }
        }
        return 0;
    }

    public static String getDesc(Integer putTargetType) {
        if (putTargetType == null) {
            return "";
        }
        for (PutTargetTypeEnum typeEnum : values()) {
            if (typeEnum.getPutTargetType().equals(putTargetType)) {
                return typeEnum.getDesc();
            }
        }
        return "";
    }

    public static PutTargetTypeEnum getByCode(Integer code){
        for(PutTargetTypeEnum enumVal : PutTargetTypeEnum.values()){
            if(code == enumVal.getPutTargetType()){
                return enumVal;
            }
        }
        return null;
    }
    
    public Integer getPutTargetType() {
        return putTargetType;
    }

    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

