package cn.com.tuia.advert.message.producter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import cn.com.tuia.advert.message.producter.message.Message;

/**
 * 消息派发
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisAbstractMsgPublisher.java , v 0.1 2017/3/10 上午9:58 ZhouFeng Exp $
 */
public class MsgPublisherDispatcher implements ApplicationContextAware {

    private Logger                                                                         logger = LoggerFactory.getLogger(getClass());

    private ConcurrentHashMap<Class<? extends AbstractMsgPublisher>, AbstractMsgPublisher> publishers;

    public void publish(Message message) {

        if (message == null) {
            logger.error("message is null");
            throw new IllegalArgumentException("message should not be null");
        }

        // 通过Message中的MessageServer注解获取发送该类消息的service
        MessagePublisher service = message.getClass().getAnnotation(MessagePublisher.class);
        if (service.value().getClass().equals(AbstractMsgPublisher.class)) {
            logger.error("Message annotation should not be AbstractMsgPublisher");
            throw new IllegalArgumentException();
        }
        AbstractMsgPublisher publisher = publishers.get(service.value());
        if (publisher == null) {
            logger.error("{} not exist in IOC", service.value().getSimpleName());
            throw new NullPointerException();
        }

        // 如果实现了MessageConvertible，则调用toMessage转换消息内容
        if (message instanceof MessageConvertible) {
            ((MessageConvertible) message).toMessage();
        }

        publisher.publish(message);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, AbstractMsgPublisher> beans = applicationContext.getBeansOfType(AbstractMsgPublisher.class);
        publishers = new ConcurrentHashMap<>(beans.size());
        for (AbstractMsgPublisher publisher : beans.values()) {
            publishers.put(publisher.getClass(), publisher);
        }
    }
}
