package cn.com.tuia.advert.model.messageDto;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:广告通知消息体 &lt;br/&gt;
 * Function:  ADD FUNCTION. &lt;br/&gt;
 * Date:     20190808  &lt;br/&gt;
 *
 * @author chencheng
 * @see
 * @since JDK 1.8
 */
public class AdxAdvertMsg implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新所有广告内存.
     */
    public static final int UPDATE_ALL = 0;

    /**
     * 更新特定列表中的广告内存.
     */
    public static final int UPDATE_TRAGET = 1;

    /**
     * 0：更新所有广告内存，1：更新特定列表中的广告内存.
     */
    private Integer type;

    /**
     * Dsp 平台id
     */
    private Long dspId;

    /**
     * The ids.
     */
    private List<Long> ids;

    /**
     * 广告类型，1-互动、2-展示、3-激励
     */
    private Integer advertType;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public AdxAdvertMsg(Integer type, Integer advertType, Long dspId, List<Long> ids) {
        super();
        this.type = type;
        this.ids = ids;
        this.dspId = dspId;
        this.advertType = advertType;
    }


}
