package cn.com.tuia.advert.model.messageDto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 新媒体测试2.0 消息对象
 * @author lijicong
 * @since 2021-08-03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MediaMesageDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /** 媒体id */
    private Long appId;
    /** 缓存类型 {@link CacheType} */
    private Integer type;
    /** 广告id */
    private Long advertId;

    @AllArgsConstructor
    @Getter
    public enum CacheType {
        newMediaCache(1, "新媒体缓存"),
        backflowAdvertsCache(2, "回流广告缓存"),
        overMaxLaunchAdvertIdsCache(3, "超过最大发券的广告ID缓存"),
        dayAdvertIdAppIdCache(4, "每日发券缓存"),
        advertPackageBlacklistCache(5, "广告配置黑名单缓存"),
        ;
        private final int code;
        private final String desc;
        public static Map<Integer, CacheType> map = Arrays.stream(CacheType.values())
                .collect(Collectors.toMap(CacheType::getCode, e -> e));

        public static CacheType of(Integer code) {
            return map.getOrDefault(code, CacheType.newMediaCache);
        }
    }
}
