package cn.com.tuia.advert.service;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.tuia.advert.fallback.AdxEngineServiceFallbackImpl;
import cn.com.tuia.advert.fallback.IAdxServiceFallbackImpl;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

/**
 * 大盘(tuia-engine调用的)adx出券请求接口
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@AdvancedFeignClient(fallback = IAdxServiceFallbackImpl.class)
public interface IAdxService {

    /**
     * 活动预发券请求, act-web调用80ms熔断
     *
     * @param req
     *  req#adxLoadType，1：预发券
     *  req#adxMediaType，1：互动直投API
     *  @fallback 降级处理，请做好兼容
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "actPre-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
            @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
            @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "120")
    })
    ObtainAdvertRsp actPreLoadAdvert(ObtainAdvertReq req);

    /**
     * adx预发券请求（tuia-engine用）
     *
     *  当请求是美团adx时，我方作为dsp返回广告券的同时将记录发券订单等数据
     *
     * @param req  req#adxLoadType，1：预发券
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#preLoadAdvert}
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
        @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
        @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "200")
    })
    ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req);

    /**
     * adx真实发券请求(tuia-engine用)
     *
     * @param req  req#adxLoadType 2：真实发券
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#actLoadAdvert}
     * @return
     */
    ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req);

    /**
     * 日志补偿
     *
     * 1、美团adx请求发券时，我方作为dsp返回广告券：请求 IAdxService#preLoadAdvert 接口返回预出的广告券
     * 2、当在美团adx成功竞价，广告券曝光时，将调用此接口进行日志补偿，将会对以下日志进行补偿：
     *      a、请求日志
     *      b、发券日志
     *      c、曝光日志
     * 3、追加领券记录及时段发券量
     * 3、点击及计费日志走原有的逻辑，详情：{@link ISpmService#clickLog(cn.com.tuia.advert.model.SpmlogReq)}
     *
     * @param logReq    请求参数
     * @return          日志补偿是否成功
     */
    boolean reLog(AdxLogReq logReq);

}
