/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum NetTypeEnum {
    GSM(1, "4G"),
    WIFI(2, "wifi"),
    UNKNOW(3, "unknow");

    private Integer code;
    private String tyte;
    private static Map<Integer, NetTypeEnum> enumMapByCode;
    private static Map<String, NetTypeEnum> enumMapByName;

    private NetTypeEnum(Integer code, String tyte) {
        this.code = code;
        this.tyte = tyte;
    }

    public static NetTypeEnum getByCode(Integer code) {
        return enumMapByCode.get(code);
    }

    public static NetTypeEnum getByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        return enumMapByName.get(name.toLowerCase());
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getTyte() {
        return this.tyte;
    }

    public void setTyte(String tyte) {
        this.tyte = tyte;
    }

    static {
        enumMapByCode = Maps.newHashMap();
        enumMapByName = Maps.newHashMap();
        for (NetTypeEnum netTypeEnum : NetTypeEnum.values()) {
            enumMapByCode.put(netTypeEnum.getCode(), netTypeEnum);
            enumMapByName.put(netTypeEnum.getTyte(), netTypeEnum);
        }
    }
}

