/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum PlatformTypeEnum {
    ANDROID(1, "android", "\u5b89\u5353"),
    IOS(2, "ios", "\u82f9\u679c"),
    UNKNOW(3, "unknow", "\u5176\u5b83");

    private String desc;
    private Integer code;
    private String cName;
    private static Map<String, PlatformTypeEnum> enumMap;

    private PlatformTypeEnum(Integer code, String desc, String cName) {
        this.desc = desc;
        this.code = code;
        this.cName = cName;
    }

    public String getcName() {
        return this.cName;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static PlatformTypeEnum getByDesc(String desc) {
        PlatformTypeEnum platformType = enumMap.get(desc.toLowerCase());
        return platformType == null ? UNKNOW : platformType;
    }

    static {
        enumMap = Maps.newHashMap();
        for (PlatformTypeEnum it : PlatformTypeEnum.values()) {
            enumMap.put(it.getDesc(), it);
        }
    }
}

