package cn.com.tuia.advert.enums;

/**
 * 直投替换互动原因类型枚举
 *
 * @author lijian
 * @date 2019/4/10
 * @since JDK 1.8
 */
public enum DirectReplaceHdEnum {

    HIT_ADVERT_SEND_NO1("1.1.1.1", "仅命中互动广告白名单配置且替换广告配置停投发券失败"),
    HIT_ADVERT_SEND_NO2("1.1.1.2", "仅命中互动广告白名单配置且替换广告配置无预算发券失败"),
    HIT_ADVERT_SEND_YES("1.1.1.3", "仅命中互动广告白名单配置且发券成功"),

    HIT_ARPU_SEND_NO1("1.2.1.1", "仅命中arpu配置且替换广告配置停投发券失败"),
    HIT_ARPU_SEND_NO2("1.2.1.2", "仅命中arpu配置且替换广告配置无预算发券失败"),
    HIT_ARPU_SEND_YES("1.2.1.3", "仅命中arpu配置且发券成功"),

    HIT_ALL_SEND_NO1("1.3.1.1", "都命中且替换广告配置停投发券失败"),
    HIT_ALL_SEND_NO2("1.3.1.2", "都命中且替换广告配置无预算发券失败"),
    HIT_ALL_SEND_YES("1.3.1.3", "都命中配置且发券成功"),

    NOT_HIT("2.1.0.0", "未命中且发券失败"),
    ;

    private String code;

    private String desc;

    DirectReplaceHdEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
