package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

public enum NetTypeEnum {
/**这里命名tyte 统一用小写  不然getByName 做了统一小写处理 ,拿不到值 */
    GSM(1,"4G"),
    WIFI(2,"wifi"),
    UNKNOW(3,"unknow");
    private Integer code;
    private String tyte;

    NetTypeEnum(Integer code, String tyte) {
        this.code = code;
        this.tyte = tyte;
    }

    private static Map<Integer,NetTypeEnum> enumMapByCode= Maps.newHashMap();
    private static Map<String,NetTypeEnum> enumMapByName= Maps.newHashMap();

    static {
        for (NetTypeEnum netTypeEnum : NetTypeEnum.values()) {
            enumMapByCode.put(netTypeEnum.getCode(), netTypeEnum);
            enumMapByName.put(netTypeEnum.getTyte(),netTypeEnum);
        }
    }

    public static NetTypeEnum getByCode(Integer code){
        return enumMapByCode.get(code);
    }

    public static NetTypeEnum getByName(String name) {
        if(StringUtils.isBlank(name)) {
            return null;
        }
        return enumMapByName.get(name.toLowerCase());
    }

        public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getTyte() {
        return tyte;
    }

    public void setTyte(String tyte) {
        this.tyte = tyte;
    }
}
