package cn.com.tuia.advert.message.producter.message;

import com.alibaba.fastjson.annotation.JSONField;

import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.producter.MessagePublisher;
import cn.com.tuia.advert.message.producter.RedisMsgPublisher;

/**
 * Redis消息
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisMessage.java , v 0.1 2017/3/10 上午10:41 ZhouFeng Exp $
 */
@MessagePublisher(RedisMsgPublisher.class)
public class RedisMessage extends Message {

    @JSONField(serialize = false)
    protected RedisMessageChannel channel;

    @JSONField(serialize = false)
    protected String              message;

    public RedisMessage() {
    }

    public RedisMessage(RedisMessageChannel channel, String message) {
        this.channel = channel;
        this.message = message;
    }

    public RedisMessageChannel getChannel() {
        return channel;
    }

    public void setChannel(RedisMessageChannel channel) {
        this.channel = channel;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
