package cn.com.tuia.advert.cache;

/**
 * 缓存枚举
 *
 * @author lijicong
 * @since 2021-08-02
 */
public interface CacheKeyEnumerable {

    String SEPARATOR = "_";

    String getKey();

    default String getSpace() {
        return "MANGO";
    }

    default String getSeparator() {
        return SEPARATOR;
    }

    default String appendKey(Object... keySuffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(getSpace()).append(getSeparator()).append(getKey());
        if (keySuffix != null) {
            for (Object temp : keySuffix) {
                sb.append(getSeparator());
                sb.append(temp);
            }
        }
        return sb.toString();
    }

}
