package cn.com.tuia.advert.directAdvertService;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.ObtainDirectAdvertReq;
import cn.com.tuia.advert.model.ObtainDirectAdvertRsp;
import cn.com.tuia.advert.model.QueryDirectAdvertReq;
import cn.com.tuia.advert.model.QueryDirectAdvertRsp;

@AdvancedFeignClient
public interface DirectAdvertEngineService {

    /**
     * 请求激励广告接口(出券).
     */
    ObtainDirectAdvertRsp obtainDirectAdvert(ObtainDirectAdvertReq req) throws ReadableMessageException;

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    QueryDirectAdvertRsp queryAdvert(QueryDirectAdvertReq req) throws ReadableMessageException;
}
