package cn.com.tuia.advert.model;

import java.io.Serializable;

/**
 * @author fanjia
 * @date 2021年11月25日 下午2:26
 */

public class AdxDirectAdvertDto implements Serializable {
    private static final long serialVersionUID = -6827246815657910300L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 配置包id
     */
    private Long orientationId;


    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估出价
     */
    private Long fee;




    /**
     * 订单ID
     */
    private String orderId;



    /**
     * 素材id-（流量线传递的创意素材id	）
     */
    private Long unitId;

    /**
     *创意计划id集合	-（流量线那边传递的。反查回来的）
     */
    private Long ideaId;


    /** 深度链接 dp链接 */
    private String promoteDeepLink;

    /** app下载链接（apk链接）*/
    private String appDownloadUrl;


    /** 落地页-推广网址. */
    private String promoteUrl;

    // 广告的sdk信息
    private AdvertSdkDto advertSdkDto;

    /** 广告推广计划-应用下载类型的相关字段*/
    private AdvertAppInfoDto advertAppInfoDto;


    /**
     * 素材id-该字段对流量线没用.流量线取的是adxMaterialId  这个代表是我们的素材.前期两边素材没打通之前 这个值=unitId
     * 等下个去求两边素材打通以后 unitId某种映射关系后=materialId   会来我们素材表占坑
     *
     */
    private Long materialId;

    /**
     * 调价因子
     */
    private Double adjustPriceFactor;


    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     *  algo返回的价格.cpm的价格.
     * @author fanjia
     * @date 2021/12/28 下午2:31
     * @param null
     * @return null
     */
    private Long bidPrice;



    /**
     * 维稳因子
     */
    private Double factor;


    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 融合ctr
     */
    private Double ctr;


    /**
     * 融合pv
     */
    private Double launchPv;

    /**
     * 预估pv
     */
    private Double preLaunchPv;

    /**
     * 统计pv
     */
    private Double statLaunchPv;

    /**
     * 融合arpu
     */
    private Double mixArpu;

    /**
     * 统计arpu
     */
    private Double arpu;
    /**
     * 预估arpu
     */
    private Double preArpu;

    public Double getLaunchPv() {
        return launchPv;
    }

    public void setLaunchPv(Double launchPv) {
        this.launchPv = launchPv;
    }

    public Double getPreLaunchPv() {
        return preLaunchPv;
    }

    public void setPreLaunchPv(Double preLaunchPv) {
        this.preLaunchPv = preLaunchPv;
    }

    public Double getStatLaunchPv() {
        return statLaunchPv;
    }

    public void setStatLaunchPv(Double statLaunchPv) {
        this.statLaunchPv = statLaunchPv;
    }

    public Double getMixArpu() {
        return mixArpu;
    }

    public void setMixArpu(Double mixArpu) {
        this.mixArpu = mixArpu;
    }

    public Double getArpu() {
        return arpu;
    }

    public void setArpu(Double arpu) {
        this.arpu = arpu;
    }

    public Double getPreArpu() {
        return preArpu;
    }

    public void setPreArpu(Double preArpu) {
        this.preArpu = preArpu;
    }

    public Double getFactor() {
        return factor;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }

    public Double getStatCtr() {
        return statCtr;
    }

    public void setStatCtr(Double statCtr) {
        this.statCtr = statCtr;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getBidPrice() {
        return bidPrice;
    }

    public void setBidPrice(Long bidPrice) {
        this.bidPrice = bidPrice;
    }

    public Double getAdjustPriceFactor() {
        return adjustPriceFactor;
    }

    public void setAdjustPriceFactor(Double adjustPriceFactor) {
        this.adjustPriceFactor = adjustPriceFactor;
    }

    public Double getPreCvr() {
        return preCvr;
    }

    public void setPreCvr(Double preCvr) {
        this.preCvr = preCvr;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public AdvertSdkDto getAdvertSdkDto() {
        return advertSdkDto;
    }

    public void setAdvertSdkDto(AdvertSdkDto advertSdkDto) {
        this.advertSdkDto = advertSdkDto;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Double getPreCtr() {
        return preCtr;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public String getPromoteDeepLink() {
        return promoteDeepLink;
    }

    public void setPromoteDeepLink(String promoteDeepLink) {
        this.promoteDeepLink = promoteDeepLink;
    }

    public String getAppDownloadUrl() {
        return appDownloadUrl;
    }

    public void setAppDownloadUrl(String appDownloadUrl) {
        this.appDownloadUrl = appDownloadUrl;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public AdvertAppInfoDto getAdvertAppInfoDto() {
        return advertAppInfoDto;
    }

    public void setAdvertAppInfoDto(AdvertAppInfoDto advertAppInfoDto) {
        this.advertAppInfoDto = advertAppInfoDto;
    }
}
