package cn.com.tuia.advert.constants;

/**
 * 广告发券监控常量
 *
 * @author peanut.huang
 * @date 2019/8/9
 * @since JDK 1.8
 */
public class AdvertLaunchMonitorConstant {


    /**
     *  广告发券监控rocketMq消息消费tag
     */
    public static final String ADVERT_LAUNCH_MONITOR_TAG = "advertLaunchMonitorTag";

    /**
     * 屏蔽的标签类型
     */
    public static class BannedType {

        // 应用维度
        /**
         * 应用标签(行业，属性 -- 包括应用管理和流量策略)
         */
        public static final String APP_TAG = "appTag";

        /**
         * 应用落地页标签（应用管理）
         */
        public static final String APP_PROMOTE_MGT_TAG = "appPromoteMgtTag";

        /**
         * 应用落地页标签（流量策略）
         */
        public static final String APP_PROMOTE_FLOW_TAG = "appPromoteFlowTag";

        /**
         * 应用素材标签
         */
        public static final String APP_MATERIAL_TAG = "appMaterialTag";
        // ---------------------------------------------------------------------


        // 广告位维度
        /**
         * 广告位标签(行业，属性 -- 包括应用管理和流量策略)
         */
        public static final String SLOT_TAG = "slotTag";


        /**
         * 广告位落地页标签（应用管理）
         */
        public static final String SLOT_PROMOTE_MGT_TAG = "slotPromoteMgtTag";

        /**
         * 广告位落地页标签（流量策略）
         */
        public static final String SLOT_PROMOTE_FLOW_TAG = "slotPromoteFlowTag";

        /**
         * 广告位流量策略素材标签
         */
        public static final String SLOT_MATERIAL_TAG = "slotMaterialTag";

        /**
         * 流量线广告位标签
         */
        public static final String SLOT_MEDIA_TAG = "slotMediaTag";


        // ---------------------------------------------------------------------

        /**
         * 广告位白名单
         */
        public static final String SLOT_WHITE_LIST = "slotWhiteList";

        /**
         * 媒体白名单
         */
        public static final String APP_WHITE_LIST = "appWhiteList";

        /**
         * 媒体广告位互选
         */
        public static final String APP_ADVERT_SELECT = "appAdvertSelect";

        /**
         * 媒体广告位互选--广告
         */
        public static final String APP_ADVERT_SELECT_ADVERT = "appAdvertSelectAdvert";

        /**
         * 媒体广告位互选--素材
         */
        public static final String APP_ADVERT_SELECT_MATERIAL = "appAdvertSelectMaterial";

    }
}
