package cn.com.tuia.advert.model;

import lombok.Data;
import java.io.Serializable;
import java.util.Map;

@Data
public class AdxAdvertRequestLog implements Serializable {

    private static final long serialVersionUID = -2001335433400488330L;

    /** 用户id */
    private Long consumerId;

    /** 发生点击事件的app的id */
    private Long appId;

    /** 广告id */
    private Long advertId;

    /** 定向配置包ID */
    private Long orientationId;

    /** 订单id，用来判断计费的次数 */
    private String orderId;

    /** 点击按钮的客户端的ip */
    private String ip;

    /** 点击按钮的客户端的UA */
    private String ua;

    /** 福袋被添加的活动ID */
    private Long activityId;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String type;

    private String userAgent;

    /** 设备价格区间 */
    private String priceSection;

    /** 在cookie中写入的设备id */
    private String deviceId;

    /** 当前系统时间 */
    private String time;

    /** 广告位ID */
    private Long slotId;

    /** 扣费金额(分) */
    private Long fee;

    /** 计费方式 */
    private String chargeType;

    /** 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20 */
    private Integer activityUseType;

    /** 活动订单ID */
    private String activityOrderId;

    /** 活动类型 */
    private String duibaActivityType;

    /** 日志扩展map，仅用于记录日志 */
    private Map<String, String> logExtMap;

    /** 1-杭州推啊，2-霍尔果斯推啊 */
    private Integer effectiveMainType;

    /** 投放类型：1-福袋 2-直投 3-浮标 */
    private int deliveryType;

    /** 激励广告打得虚拟广告位id */
    private Long virtualSlotId;

    /** 日志拓展字段，放进该字段的所有数据都将在全链路打印::key和value都不能有","整体这个字符串 */
    private Map<String, String> logExtExpMap;

    /** 城市id */
    private String cityId;

    /** 素材id */
    private Long materialId;

}
