package cn.com.tuia.advert.model;

import cn.com.duiba.tuia.algo.engine.api.adx.v4.AlgoExecuteDTO;
import lombok.Data;

import java.io.Serializable;

/**
 * @author fanjia
 * @date 2021年11月25日 下午2:26
 */

@Data
public class AdxDirectAdvertDto implements Serializable {
    private static final long serialVersionUID = -6827246815657910300L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 配置包id
     */
    private Long orientationId;

    /**
     * algo返回结果
     */
    private AlgoExecuteDTO algoExecuteDTO;

    /**
     * 预估出价
     */
    private Long fee;

    /**
     * 订单ID
     */
    private String orderId;


    /** 深度链接 dp链接 */
    private String promoteDeepLink;

    /** app下载链接（apk链接）*/
    private String appDownloadUrl;


    /** 落地页-推广网址. */
    private String promoteUrl;

    // 广告的sdk信息
    private AdvertSdkDto advertSdkDto;

    /** 广告推广计划-应用下载类型的相关字段*/
    private AdvertAppInfoDto advertAppInfoDto;


    /**
     * 素材id-该字段对流量线没用.流量线取的是adxMaterialId  这个代表是我们的素材.前期两边素材没打通之前 这个值=unitId
     * 等下个去求两边素材打通以后 unitId某种映射关系后=materialId   会来我们素材表占坑
     *
     */
    private Long materialId;

    /**
     * 调价因子
     */
    private Double adjustPriceFactor;

}
