package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by MichealWang on 2018/10/29 0029.
 * 广告ocpc后端数据 调整因子
 */
public enum AdvertSubtypeEnum {
    /**
     * 落地页转化
     */
    CVR(0, "落地页转化"),
    /**
     * 安装
     */
    INSTALL(1, "安装"),
    /**
     * 启动
     */
    START(2, "激活(启动)"),
    /**
     * 注册
     */
    REGISTER(3, "注册"),
    /**
     * 激活
     */
    ACTIVITY(4, "激活"),
    /**
     * 登录
     */
    LOGIN(5, "登录"),
    /**
     * 付费
     */
    PAY(6, "付费"),
    /**
     * 进件
     */
    ENTRY(7, "进件"),
    /**
     * 完件
     */
    FINISH(8, "完件"),
    /**
     * 签收
     */
    SIGN_FOR(9, "签收"),
    /**
     * 留存
     */
    DENY(10, "拒签"),

    /**
     * 出单
     */
    OUT_ORDER(11, "出单"),

    ORDER_CANCEL(12, "订单取消"),
    BUSI_AUDIT_NO(13, "商家审核不通过"),
    AUDIT_PASS(14, "审核通过"),
    CUST_AUDIT_NO(15, "客服审核不通过"),
    BUSI_CANCEL_SEND(16, "商家取消发货"),
    CUST_CANCEL_SEND(17, "客服取消发货"),
    ROBOT_CANCEL_SEND(18, "机器人取消发货"),

    LANDING_TIME_CONSUME(19, "落地页首页停留时长超过5s"),
    EFFECT_ORDER_COUNT(23, "有效订单数"),
    ;
    public static HashMap<Integer, AdvertSubtypeEnum> ADVERT_SUBTYPE_MAPPING = Maps.newHashMap();

    static {

        for (AdvertSubtypeEnum advertSubtypeEnum : AdvertSubtypeEnum.values()) {
            ADVERT_SUBTYPE_MAPPING.put(advertSubtypeEnum.getSubtype(),advertSubtypeEnum);
        }

    }

    private Integer subtype;

    private String desc;

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    AdvertSubtypeEnum(Integer subtype, String desc) {
        this.subtype = subtype;
        this.desc = desc;
    }

    public static AdvertSubtypeEnum getSubtypeEnumBySubtype(Integer subtype) {
        return ADVERT_SUBTYPE_MAPPING.get(subtype);
    }

    private static Map<Integer, AdvertSubtypeEnum> enumMap = Maps.newHashMap();

    static {
        for (AdvertSubtypeEnum it : AdvertSubtypeEnum.values()) {
            enumMap.put(it.getSubtype(), it);
        }
    }

    public static AdvertSubtypeEnum getBySubtype(Integer subtype) {
        return enumMap.get(subtype);
    }

}
