/**
 * 文件名： IEngineService.java<br/>
 * 此类描述的是： <br/>
 * 作者: sunjiangrong <br/>
 * 创建时间: 2016年4月27日 下午10:29:43 <br/>
 */
package cn.com.tuia.advert.remoteService;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.ObtainShowAdvertListRsp;
import cn.com.tuia.advert.model.ObtainShowAdvertReq;
import cn.com.tuia.advert.model.QueryAdvertReq;
import cn.com.tuia.advert.model.QueryAdvertRsp;

/**
 * 
 * ClassName: ShowEngineService <br/>
 * Function: 展示广告引擎服务. <br/>
 * date: 2018年8月27日 下午5:40:09 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface ShowEngineService {

    /**
     * 请求展示广告接口.
     *
     * @param req the req
     * @return the obtain advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    ObtainShowAdvertListRsp obtainShowAdvert(ObtainShowAdvertReq req) throws ReadableMessageException;

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    QueryAdvertRsp queryShowAdvert(QueryAdvertReq req) throws ReadableMessageException;


    /**
     * 批量 请求展示广告接口
     * @param req
     * @return
     * @throws ReadableMessageException
     */
    ObtainShowAdvertListRsp batchObtainShowAdvert(ObtainShowAdvertReq req) throws ReadableMessageException;

}
