package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 数据类型分组
 */
public enum AdvertFiveMinBasisDataTypeEnum {

    CLICK_COUNT_LAUNCH(1,"点击（发券时间）"),
    CLICK_COUNT_NOW(2,"点击（实时）"),
    REGISTE_COUNT_LAUNCH(3,"注册（发券时间）"),
    REGISTE_COUNT_NOW(4,"注册（实时）")
    ;

    private  Integer code;

    private String desc;


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }



    AdvertFiveMinBasisDataTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }


    private static Map<Integer, AdvertFiveMinBasisDataTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertFiveMinBasisDataTypeEnum it : AdvertFiveMinBasisDataTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static String getDescByCode(Integer code) {
        return enumMap.get(code).getDesc();
    }
    public static AdvertFiveMinBasisDataTypeEnum getEnumByCode(Integer code) {
        return enumMap.get(code);
    }
}
