package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * <h3>资源对应标签类型</h3>
 * <p>
 * 从show-engine、adx-eninge、engine中抽取过来。
 * 注意advert-center-api里边还有一个类，已经打包出去其他系统在用，使用时注意。
 *
 * @author lijicong
 * @since 2021-05-20
 */
public enum ResourceTagsTypeEnum {

    /** 广告推广链接标签 */
    AD("ad", "广告推广链接标签"),

    /** 素材标签 */
    MATERIAL("material", "素材标签"),

    JIMU("jimu","积木同步标签"),

    /** 应用屏蔽的推广链接标签 */
    APP_BANNED_URL_TAG("appBannedUrlTag", "应用屏蔽的推广链接标签"),

    /** 广告分析标签 */
    ADVERT_ANALYSIS_TAG("advertAnalysisTag", "广告分析标签"),

    /** 广告位屏蔽的推广链接标签 */
    SLOT_BANNED_URL_TAG("slotBannedUrlTag", "广告位屏蔽的推广链接标签"),

    /** 广告位流量策略屏蔽的推广链接标签 */
    SLOT_FLOW_BANNED_URL_TAG("slotFlowBannedUrlTag", "广告位流量策略屏蔽的推广链接标签"),

    APP_SHIELD_MATERIAL_TAG("appShieldMaterialTag", "应用屏蔽的素材标签"),

    SLOT_FLOW_SHIELD_MATERIAL_TAG("slotFlowMaterialTag", "广告位流量策略屏蔽的素材标签"),

    SLOT_SHIELD_MATERIAL_TAG("slotMaterialTag", "应用广告位屏蔽的素材标签"),

    /** 广告资源标签 */
    ADVERT_RESOURCE_TAG("advertResourceTag", "广告资源标签"),

    APP_BANNED_RESOURCE_TAG("appBannedResourceTag", "应用屏蔽的资源标签"),

    SLOT_FLOW_BANNED_RESOURCE_TAG("slotFlowBannedRes", "广告位流量策略屏蔽的资源标签"),

    ;

    private String name;

    private String code;

    ResourceTagsTypeEnum(String code, String name) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, ResourceTagsTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (ResourceTagsTypeEnum it : ResourceTagsTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static ResourceTagsTypeEnum getByName(String name) {
        return enumMap.get(name);
    }
}
