/**
 * Project Name:tuia-clent<br>
 * File Name:ObtainAdvertExReq.java<br>
 * Package Name:cn.com.tuia.advert.model<br>
 * Date:2016年6月16日下午5:14:51<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.util.Map;

import org.joda.time.DateTime;

/**
 * ClassName: ObtainAdvertExReq <br/>
 * Function: 兑吧请求广告接口的请求参数. <br/>
 * Reason: <br/>
 * date: 2016年6月16日 下午5:14:51 <br/>
 * 
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class ObtainAdvertReq implements Serializable {

    private static final long   serialVersionUID = 1L;

    /** 点击按钮的用户id */
    private Long                consumerId;

    /** 点击按钮的客户端的UA */
    private String              ua;

    /** 承载点击按钮的订单的id，用来判断计费的次数 */
    private String              orderId;

    /** 点击按钮的客户端的ip */
    private String              ip;

    /** 发生点击事件的app的id */
    private Long                appId;

    /** 产品ID */
    private Long                productId;

    /** 福袋被添加的活动ID */
    private Long                activityId;

    /** 活动标签. */
    private String              tag;

    /** 客户端时间戳，毫秒 */
    private Long                timestamp;

    /** 登陆状态（未登录：0，登陆：1） */
    private String              loginType;

    /** 按钮埋点号码 */
    private String              buttonType;

    /** 细节类型 */
    private String              infoType;

    /** 细节 */
    private String              info;

    /** 用户使用系统 */
    private String              os;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String              type;

    private String              userAgent;

    /** 在cookie中写入的设备id */
    private String              deviceId;

    /** 使用指纹生成技术产生的指纹 */
    private String              fingerPrint;

    /** x,y坐标 */
    private String              coordinate;

    /** 浏览器名 */
    private String              browserName;

    /** 浏览器版本 */
    private String              browserVersion;

    /** 浏览器别名 */
    private String              browserAlias;

    /** url */
    private String              url;

    /** url不完全地址 */
    private String              urlPattern;

    /** 上一个url */
    private String              preUrl;

    /** 上一个url不完全地址 */
    private String              preurlPattern;

    /** 当前系统时间 */
    private String              time;

    /** 广告位ID */
    private Long                slotId;

    /** 广告ID */
    private Long                advertId;

    /** 执行结果code. */
    private String              result;

    /** 执行结果说明. */
    private String              message;

    /** 活动类型 插件活动为 1 */
    private Integer             activityType;

    /** 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20 */
    private Integer             activityUseType;

    /** 兑吧活动类型 ， 从兑吧传过来的活动类型，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Integer             duibaActivityType;

    /** 兑吧活动id ， 从兑吧传过来的活动id，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Long                duibaActivityId;

    /**  日志扩展map，仅用于记录日志 */
    private Map<String, String> logExtMap;

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public Integer getActivityUseType() {
        return activityUseType;
    }

    public void setActivityUseType(Integer activityUseType) {
        this.activityUseType = activityUseType;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public ObtainAdvertReq() {
        super();
        DateTime nowTime = new DateTime();
        String serverTime = nowTime.toString("yyyy-MM-dd HH:mm:ss");
        this.time = serverTime;
    }

    /**
     * activityType.
     * 
     * @return the activityType
     * @since JDK 1.6
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     * 
     * @param activityType the activityType to set
     * @since JDK 1.6
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * result.
     * 
     * @return the result
     * @since JDK 1.6
     */
    public String getResult() {
        return result;
    }

    /**
     * result.
     * 
     * @param result the result to set
     * @since JDK 1.6
     */
    public void setResult(String result) {
        this.result = result;
    }

    /**
     * message.
     * 
     * @return the message
     * @since JDK 1.6
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     * 
     * @param message the message to set
     * @since JDK 1.6
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * advertId.
     * 
     * @return the advertId
     * @since JDK 1.6
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     * 
     * @param advertId the advertId to set
     * @since JDK 1.6
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * slotId.
     * 
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     * 
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * timestamp.
     * 
     * @return the timestamp
     * @since JDK 1.6
     */
    public Long getTimestamp() {
        return timestamp;
    }

    /**
     * timestamp.
     * 
     * @param timestamp the timestamp to set
     * @since JDK 1.6
     */
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * time.
     * 
     * @return the time
     * @since JDK 1.6
     */
    public String getTime() {
        return time;
    }

    /**
     * time.
     * 
     * @param time the time to set
     * @since JDK 1.6
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * consumerId.
     * 
     * @return the consumerId
     * @since JDK 1.6
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * consumerId.
     * 
     * @param consumerId the consumerId to set
     * @since JDK 1.6
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * ua.
     * 
     * @return the ua
     * @since JDK 1.6
     */
    public String getUa() {
        return ua;
    }

    /**
     * ua.
     * 
     * @param ua the ua to set
     * @since JDK 1.6
     */
    public void setUa(String ua) {
        this.ua = ua;
    }

    /**
     * orderId.
     * 
     * @return the orderId
     * @since JDK 1.6
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     * 
     * @param orderId the orderId to set
     * @since JDK 1.6
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * ip.
     * 
     * @return the ip
     * @since JDK 1.6
     */
    public String getIp() {
        return ip;
    }

    /**
     * ip.
     * 
     * @param ip the ip to set
     * @since JDK 1.6
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * appId.
     * 
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     * 
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * productId.
     * 
     * @return the productId
     * @since JDK 1.6
     */
    public Long getProductId() {
        return productId;
    }

    /**
     * productId.
     * 
     * @param productId the productId to set
     * @since JDK 1.6
     */
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    /**
     * activityId.
     * 
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     * 
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * tag.
     * 
     * @return the tag
     * @since JDK 1.6
     */
    public String getTag() {
        return tag;
    }

    /**
     * tag.
     * 
     * @param tag the tag to set
     * @since JDK 1.6
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * loginType.
     * 
     * @return the loginType
     * @since JDK 1.6
     */
    public String getLoginType() {
        return loginType;
    }

    /**
     * loginType.
     * 
     * @param loginType the loginType to set
     * @since JDK 1.6
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * buttonType.
     * 
     * @return the buttonType
     * @since JDK 1.6
     */
    public String getButtonType() {
        return buttonType;
    }

    /**
     * buttonType.
     * 
     * @param buttonType the buttonType to set
     * @since JDK 1.6
     */
    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    /**
     * infoType.
     * 
     * @return the infoType
     * @since JDK 1.6
     */
    public String getInfoType() {
        return infoType;
    }

    /**
     * infoType.
     * 
     * @param infoType the infoType to set
     * @since JDK 1.6
     */
    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    /**
     * info.
     * 
     * @return the info
     * @since JDK 1.6
     */
    public String getInfo() {
        return info;
    }

    /**
     * info.
     * 
     * @param info the info to set
     * @since JDK 1.6
     */
    public void setInfo(String info) {
        this.info = info;
    }

    /**
     * os.
     * 
     * @return the os
     * @since JDK 1.6
     */
    public String getOs() {
        return os;
    }

    /**
     * os.
     * 
     * @param os the os to set
     * @since JDK 1.6
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * type.
     * 
     * @return the type
     * @since JDK 1.6
     */
    public String getType() {
        return type;
    }

    /**
     * type.
     * 
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * userAgent.
     * 
     * @return the userAgent
     * @since JDK 1.6
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     * 
     * @param userAgent the userAgent to set
     * @since JDK 1.6
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * deviceId.
     * 
     * @return the deviceId
     * @since JDK 1.6
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * deviceId.
     * 
     * @param deviceId the deviceId to set
     * @since JDK 1.6
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * fingerPrint.
     * 
     * @return the fingerPrint
     * @since JDK 1.6
     */
    public String getFingerPrint() {
        return fingerPrint;
    }

    /**
     * fingerPrint.
     * 
     * @param fingerPrint the fingerPrint to set
     * @since JDK 1.6
     */
    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    /**
     * coordinate.
     * 
     * @return the coordinate
     * @since JDK 1.6
     */
    public String getCoordinate() {
        return coordinate;
    }

    /**
     * coordinate.
     * 
     * @param coordinate the coordinate to set
     * @since JDK 1.6
     */
    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    /**
     * browserName.
     * 
     * @return the browserName
     * @since JDK 1.6
     */
    public String getBrowserName() {
        return browserName;
    }

    /**
     * browserName.
     * 
     * @param browserName the browserName to set
     * @since JDK 1.6
     */
    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    /**
     * browserVersion.
     * 
     * @return the browserVersion
     * @since JDK 1.6
     */
    public String getBrowserVersion() {
        return browserVersion;
    }

    /**
     * browserVersion.
     * 
     * @param browserVersion the browserVersion to set
     * @since JDK 1.6
     */
    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    /**
     * browserAlias.
     * 
     * @return the browserAlias
     * @since JDK 1.6
     */
    public String getBrowserAlias() {
        return browserAlias;
    }

    /**
     * browserAlias.
     * 
     * @param browserAlias the browserAlias to set
     * @since JDK 1.6
     */
    public void setBrowserAlias(String browserAlias) {
        this.browserAlias = browserAlias;
    }

    /**
     * url.
     * 
     * @return the url
     * @since JDK 1.6
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     * 
     * @param url the url to set
     * @since JDK 1.6
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * urlPattern.
     * 
     * @return the urlPattern
     * @since JDK 1.6
     */
    public String getUrlPattern() {
        return urlPattern;
    }

    /**
     * urlPattern.
     * 
     * @param urlPattern the urlPattern to set
     * @since JDK 1.6
     */
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    /**
     * preUrl.
     * 
     * @return the preUrl
     * @since JDK 1.6
     */
    public String getPreUrl() {
        return preUrl;
    }

    /**
     * preUrl.
     * 
     * @param preUrl the preUrl to set
     * @since JDK 1.6
     */
    public void setPreUrl(String preUrl) {
        this.preUrl = preUrl;
    }

    /**
     * preurlPattern.
     * 
     * @return the preurlPattern
     * @since JDK 1.6
     */
    public String getPreurlPattern() {
        return preurlPattern;
    }

    /**
     * preurlPattern.
     * 
     * @param preurlPattern the preurlPattern to set
     * @since JDK 1.6
     */
    public void setPreurlPattern(String preurlPattern) {
        this.preurlPattern = preurlPattern;
    }

    /**
     * 日志输出格式，勿删.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" [consumerId ");
        builder.append(consumerId);
        builder.append("] [ua ");
        builder.append(ua);
        builder.append("] [orderId ");
        builder.append(orderId);
        builder.append("] [ip ");
        builder.append(ip);
        builder.append("] [appId ");
        builder.append(appId);
        builder.append("] [productId ");
        builder.append(productId);
        builder.append("] [activityId ");
        builder.append(activityId);
        builder.append("] [tag ");
        builder.append(tag);
        builder.append("] [timestamp ");
        builder.append(timestamp);
        builder.append("] [loginType ");
        builder.append(loginType);
        builder.append("] [buttonType ");
        builder.append("buttonType");
        builder.append("] [infoType ");
        builder.append("infoType");
        builder.append("] [info ");
        builder.append("info");
        builder.append("] [os ");
        builder.append("os");
        builder.append("] [userAgent ");
        builder.append("userAgent");
        builder.append("] [deviceId ");
        builder.append("deviceId");
        builder.append("] [fingerPrint ");
        builder.append("fingerPrint");
        builder.append("] [coordinate ");
        builder.append("coordinate");
        builder.append("] [browserName ");
        builder.append("browserName");
        builder.append("] [browserVersion ");
        builder.append("browserVersion");
        builder.append("] [browserAlias ");
        builder.append("browserAlias");
        builder.append("] [url ");
        builder.append("url");
        builder.append("] [urlPattern ");
        builder.append("urlPattern");
        builder.append("] [preUrl ");
        builder.append("preUrl");
        builder.append("] [preurlPattern ");
        builder.append("preurlPattern");
        builder.append("] [serverTime ");
        builder.append("serverTime");
        builder.append("] [slotId ");
        builder.append("slotId");
        builder.append("]");
        return builder.toString();
    }
}
