/**
 * Project Name:tuia-clent<br>
 * File Name:ObtainAdvertExReq.java<br>
 * Package Name:cn.com.tuia.advert.model<br>
 * Date:2016年6月16日下午5:14:51<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.model;

import java.io.Serializable;

/**
 * ClassName: ObtainAdvertReqLogExt <br/>
 * Function: 兑吧请求广告接口的请求日志扩展对象，一些基于请求对象的日志扩展属性. <br/>
 * Reason: <br/>
 * date: 2017年1月4日 下午5:14:51 <br/>
 * 
 * @author cdm
 * @version
 * @since JDK 1.7
 */
public class ObtainAdvertReqLogExt extends ObtainAdvertReq implements Serializable {

    private static final long serialVersionUID = 7408303732217597930L;

    /** 素材ID */
    private Long              materialId;

    /** 广告出价(分). */
    private Long              fee;

    /** 设备价格区间 */
    private String            priceSection;

    /** 发券次序，该用户当日发券次数 */
    private Long              putIndex;

    /** 城市 */
    private String            cityId;

    /** 手机类型 */
    private String            model;

    /** 活动订单ID */
    private String            activityOrderId;
    
    /**发券时间点*/
    private String            hour;
    
    

    
    public String getPriceSection() {
        return priceSection;
    }

    
    public void setPriceSection(String priceSection) {
        this.priceSection = priceSection;
    }

    public String getActivityOrderId() {
        return activityOrderId;
    }

    public void setActivityOrderId(String activityOrderId) {
        this.activityOrderId = activityOrderId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }


    public Long getPutIndex() {
        return putIndex;
    }

    public void setPutIndex(Long putIndex) {
        this.putIndex = putIndex;
    }

    public String getCityId() {
        return cityId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    /**
     * materialId.
     * 
     * @return the materialId
     * @since JDK 1.6
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * materialId.
     * 
     * @param materialId the materialId to set
     * @since JDK 1.6
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }


    
    public String getHour() {
        return hour;
    }


    public void setHour(String hour) {
        this.hour = hour;
    }
    
}
