/**
 * 文件名： SpmlogReq.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月20日 下午7:42:04
 */
package cn.com.tuia.advert.model;

import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.Map;

/**
 * 打点日志请求参数
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月20日 下午7:42:04
 * @version:
 */
public class SpmlogReq implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 点击按钮的用户id */
    private Long              consumerId;

    /** 发生点击事件的app的id */
    private Long              appId;

    /** 被点击按钮的广告id */
    private Long              advertId;

    /**
     * 定向配置包ID
     */
    private Long orientationId;

    /** 承载点击按钮的订单的id，用来判断计费的次数 */
    private String            orderId;

    /** 点击按钮的客户端的ip */
    private String            ip;

    /** 点击按钮的客户端的UA */
    private String            ua;

    /** 福袋被添加的活动ID */
    private Long              activityId;

    /** 暂时仅指福袋 */
    private Integer           channel;

    /** 区分广告曝光/点击位置的标识,0(弹层)，1(弹层详情页)，2(兑换记录详情页) */
    private Integer           locationId;

    /** 客户端时间戳，毫秒 */
    private Long              timestamp;

    /** 登陆状态（未登录：0，登陆：1） */
    private String            loginType;

    /** 按钮埋点号码 */
    private String            buttonType;

    /** 细节类型 */
    private String            infoType;

    /** 细节 */
    private String            info;

    /** 用户使用系统 */
    private String            os;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String            type;

    private String            userAgent;

    /** 在cookie中写入的设备id */
    private String            deviceId;

    /** 使用指纹生成技术产生的指纹 */
    private String            fingerPrint;

    /** x,y坐标 */
    private String            coordinate;

    /** 浏览器名 */
    private String            browserName;

    /** 浏览器版本 */
    private String            browserVersion;

    /** 浏览器别名 */
    private String            browserAlias;

    /** url */
    private String            url;

    /** url不完全地址 */
    private String            urlPattern;

    /** 上一个url */
    private String            preUrl;

    /** 上一个url不完全地址 */
    private String            preurlPattern;

    /** 当前系统时间 */
    private String            time;

    /** 广告位ID */
    private Long              slotId;

    /** 扣费金额(分) */
    private Long              fee;
    
    /** 计费方式 */
    private String            chargeType;

    /** 素材ID 确认展示的素材 */
    private Long              materialId;
    
    /** 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20 */
    private Integer           activityUseType;
    
    /** 活动订单ID */
    private String            activityOrderId;
    
    /**活动类型*/
    private String            duibaActivityType;

    /**  日志扩展map，仅用于记录日志 */
    private Map<String, String> logExtMap;
    
    /**
     * chargeType.
     *
     * @return  the chargeType
     */
    public String getChargeType() {
        return chargeType;
    }
    
    /**
     * chargeType.
     *
     * @param   chargeType    the chargeType to set
     */
    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public String getActivityOrderId() {
        return activityOrderId;
    }

    public void setActivityOrderId(String activityOrderId) {
        this.activityOrderId = activityOrderId;
    }
    

    
    public Integer getActivityUseType() {
        return activityUseType;
    }

    
    public void setActivityUseType(Integer activityUseType) {
        this.activityUseType = activityUseType;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public SpmlogReq() {
        super();
        DateTime nowTime = new DateTime();
        String serverTime = nowTime.toString("yyyy-MM-dd HH:mm:ss");
        this.time = serverTime;
    }

    /**
     * fee.
     *
     * @return the fee
     * @since JDK 1.6
     */
    public Long getFee() {
        return fee;
    }

    /**
     * fee.
     *
     * @param fee the fee to set
     * @since JDK 1.6
     */
    public void setFee(Long fee) {
        this.fee = fee;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * time.
     *
     * @return the time
     * @since JDK 1.6
     */
    public String getTime() {
        return time;
    }

    /**
     * time.
     *
     * @param time the time to set
     * @since JDK 1.6
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * type.
     *
     * @return the type
     * @since JDK 1.6
     */
    public String getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * deviceId.
     *
     * @return the deviceId
     * @since JDK 1.6
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * deviceId.
     *
     * @param deviceId the deviceId to set
     * @since JDK 1.6
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * fingerPrint.
     *
     * @return the fingerPrint
     * @since JDK 1.6
     */
    public String getFingerPrint() {
        return fingerPrint;
    }

    /**
     * fingerPrint.
     *
     * @param fingerPrint the fingerPrint to set
     * @since JDK 1.6
     */
    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    /**
     * coordinate.
     *
     * @return the coordinate
     * @since JDK 1.6
     */
    public String getCoordinate() {
        return coordinate;
    }

    /**
     * coordinate.
     *
     * @param coordinate the coordinate to set
     * @since JDK 1.6
     */
    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    /**
     * browserName.
     *
     * @return the browserName
     * @since JDK 1.6
     */
    public String getBrowserName() {
        return browserName;
    }

    /**
     * browserName.
     *
     * @param browserName the browserName to set
     * @since JDK 1.6
     */
    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    /**
     * browserVersion.
     *
     * @return the browserVersion
     * @since JDK 1.6
     */
    public String getBrowserVersion() {
        return browserVersion;
    }

    /**
     * browserVersion.
     *
     * @param browserVersion the browserVersion to set
     * @since JDK 1.6
     */
    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    /**
     * browserAlias.
     *
     * @return the browserAlias
     * @since JDK 1.6
     */
    public String getBrowserAlias() {
        return browserAlias;
    }

    /**
     * browserAlias.
     *
     * @param browserAlias the browserAlias to set
     * @since JDK 1.6
     */
    public void setBrowserAlias(String browserAlias) {
        this.browserAlias = browserAlias;
    }

    /**
     * url.
     *
     * @return the url
     * @since JDK 1.6
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     *
     * @param url the url to set
     * @since JDK 1.6
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * urlPattern.
     *
     * @return the urlPattern
     * @since JDK 1.6
     */
    public String getUrlPattern() {
        return urlPattern;
    }

    /**
     * urlPattern.
     *
     * @param urlPattern the urlPattern to set
     * @since JDK 1.6
     */
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    /**
     * preUrl.
     *
     * @return the preUrl
     * @since JDK 1.6
     */
    public String getPreUrl() {
        return preUrl;
    }

    /**
     * preUrl.
     *
     * @param preUrl the preUrl to set
     * @since JDK 1.6
     */
    public void setPreUrl(String preUrl) {
        this.preUrl = preUrl;
    }

    /**
     * preurlPattern.
     *
     * @return the preurlPattern
     * @since JDK 1.6
     */
    public String getPreurlPattern() {
        return preurlPattern;
    }

    /**
     * preurlPattern.
     *
     * @param preurlPattern the preurlPattern to set
     * @since JDK 1.6
     */
    public void setPreurlPattern(String preurlPattern) {
        this.preurlPattern = preurlPattern;
    }

    /**
     * loginType.
     *
     * @return the loginType
     * @since JDK 1.6
     */
    public String getLoginType() {
        return loginType;
    }

    /**
     * loginType.
     *
     * @param loginType the loginType to set
     * @since JDK 1.6
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * buttonType.
     *
     * @return the buttonType
     * @since JDK 1.6
     */
    public String getButtonType() {
        return buttonType;
    }

    /**
     * buttonType.
     *
     * @param buttonType the buttonType to set
     * @since JDK 1.6
     */
    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    /**
     * infoType.
     *
     * @return the infoType
     * @since JDK 1.6
     */
    public String getInfoType() {
        return infoType;
    }

    /**
     * infoType.
     *
     * @param infoType the infoType to set
     * @since JDK 1.6
     */
    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    /**
     * info.
     *
     * @return the info
     * @since JDK 1.6
     */
    public String getInfo() {
        return info;
    }

    /**
     * info.
     *
     * @param info the info to set
     * @since JDK 1.6
     */
    public void setInfo(String info) {
        this.info = info;
    }

    /**
     * os.
     *
     * @return the os
     * @since JDK 1.6
     */
    public String getOs() {
        return os;
    }

    /**
     * os.
     *
     * @param os the os to set
     * @since JDK 1.6
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * userAgent.
     *
     * @return the userAgent
     * @since JDK 1.6
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     *
     * @param userAgent the userAgent to set
     * @since JDK 1.6
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * @return the consumerId
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * @param consumerId the consumerId to set
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * @param appId the appId to set
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * @return the advertId
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * @param advertId the advertId to set
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * @return the ip
     */
    public String getIp() {
        return ip;
    }

    /**
     * @param ip the ip to set
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * @return the ua
     */
    public String getUa() {
        return ua;
    }

    /**
     * @param ua the ua to set
     */
    public void setUa(String ua) {
        this.ua = ua;
    }

    /**
     * @return the activityId
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * @param activityId the activityId to set
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * @return the channel
     */
    public Integer getChannel() {
        return channel;
    }

    /**
     * @param channel the channel to set
     */
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    /**
     * @return the locationId
     */
    public Integer getLocationId() {
        return locationId;
    }

    /**
     * @param locationId the locationId to set
     */
    public void setLocationId(Integer locationId) {
        this.locationId = locationId;
    }

    /**
     * @return the timestamp
     */
    public Long getTimestamp() {
        return timestamp;
    }

    /**
     * @param timestamp the timestamp to set
     */
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }
    
    
    public String getDuibaActivityType() {
        return duibaActivityType;
    }

    
    public void setDuibaActivityType(String duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    /**
     * 日志输出格式，勿删.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" [consumerId ");
        builder.append(consumerId);
        builder.append("] [appId ");
        builder.append(appId);
        builder.append("] [advertId ");
        builder.append(advertId);
        builder.append("] [orderId ");
        builder.append(orderId);
        builder.append("] [ip ");
        builder.append(ip);
        builder.append("] [ua ");
        builder.append(ua);
        builder.append("] [activityId ");
        builder.append(activityId);
        builder.append("] [channel ");
        builder.append(channel);
        builder.append("] [locationId ");
        builder.append(locationId);
        builder.append("] [timestamp ");
        builder.append(timestamp);
        builder.append("] [loginType ");
        builder.append(loginType);
        builder.append("] [buttonType ");
        builder.append("buttonType");
        builder.append("] [infoType ");
        builder.append("infoType");
        builder.append("] [info ");
        builder.append("info");
        builder.append("] [os ");
        builder.append("os");
        builder.append("] [userAgent ");
        builder.append("userAgent");
        builder.append("] [deviceId ");
        builder.append("deviceId");
        builder.append("] [fingerPrint ");
        builder.append("fingerPrint");
        builder.append("] [coordinate ");
        builder.append("coordinate");
        builder.append("] [browserName ");
        builder.append("browserName");
        builder.append("] [browserVersion ");
        builder.append("browserVersion");
        builder.append("] [browserAlias ");
        builder.append("browserAlias");
        builder.append("] [url ");
        builder.append("url");
        builder.append("] [urlPattern ");
        builder.append("urlPattern");
        builder.append("] [preUrl ");
        builder.append("preUrl");
        builder.append("] [preurlPattern ");
        builder.append("preurlPattern");
        builder.append("] [slotId ");
        builder.append("slotId");
        builder.append("]");
        return builder.toString();
    }

}
