package cn.com.tuia.advert.message;

/**
 * Redis 消息频道
 *
 * @author ElinZhou
 * @version $Id: RedisMessageChannel.java , v 0.1 2017/3/10 上午10:03 ElinZhou Exp $
 */
public enum RedisMessageChannel {

     /**
      * 更新广告对象
      */
     UPDATE_ADVERTS_MSG("updateAdvertsMsg"),

    /**
     * 更新广告有效列表
     */
    UPDATE_VALID_ADVERTS_MSG("updateValidAdvertsMsg"),

    /**
     * 更新限流媒体列表
     */
    UPDATE_ADVERT_LIMITING_MSG("updateAdvertLimitingMsg"),
    /**
     * 更新限流媒体缓存，billing发送
     */
    UPDATE_ADVERT_LIMITING_CACHE_MSG("updateAdvertLimitingCacheMsg"),

    /**
     * 更新广告有效时段
     */
    UPDATE_PERIOD_ISPUT_NEW_MSG("updatePeriodIsputNewMsg"),

    /**
     * 接收billing有效消息难时段有效性
     */
    UPDATE_CHECK_PERIOD_ISPUT_MSG("checkPeriodIsputMsg"),

    /**
     * 更新配置包消息
     */
    UPDATE_ADVERT_ORIENT_PACKAGE_MSG("updateAdvertOrientPackageMsg"),

     /**
      * 更新广告标签消息
      */
     UPDATE_ADVERT_TAG_MSG("updateAdvertTagMsg"),

    /**
     * 更新定向包预算消息
     **/
    UPDATE_ADVERT_PKG_PUT_MSG("updateAdvertPkgPutFlag"),

    /**
     * 更新特权媒体库
     */
    UPDATE_PRIVILEGE_APP_MSG("updatePrivilegeAppMsg"),

    /**
     * 广告标签缓存更新消息
     */
    UPDATE_PRIVILEGE_ADVERT_MSG("updatePrivilegeAdvertMsg"),

    /**
     * 更新配置消息
     */
    UPDATE_SYSTEM_CONFIG_MSG("updateSystemConfigMsg"),

    /**
     * 更新投放时段
     */
    UPDATE_ADVERT_PERIOD("updateAdvertPeriod"),

    /**
     * 广告无效时发送消息通知
     */
    SEND_INVALID_ADVERT_DING_NOTICE("sendInvalidAdvertDingNoticeMsg"),

    /**
     * OCPC自动开启自动托管熔断处理消息
     */
    FUSING_ORIENTATION_PACKAGE("fusingOrientationPackage"),

    /**
     * 广告在福利流量上发券的消息
     */
    UPDATE_ADVERT_WELFARE_FLOW_MSG("updateAdvertWelfareFlowMsg"),

    /**
     * 寡头行业更新潜力广告主消息
     */
    UPDATE_ADVERT_OLIGRACH_TRADE_MSG("updateAdvertOligrachTradeMsg"),

    /**
     * 新媒体试投缓存更新消息
     */
    UPDATE_NEW_APP_TEST_CACHE_MSG("updateNewAppTestCacheMsg")
    ;

    private String channel;

    RedisMessageChannel(String channel) {
        this.channel = channel;
    }


    public String getChannel() {
        return channel;
    }

    public static String[] channels() {
        RedisMessageChannel[] values = values();
        int length = values.length;
        String[] channels = new String[length];
        for (int i = 0; i < length; i++) {
            channels[i] = values[i].channel;
        }
        return channels;
    }

    public static RedisMessageChannel getByChannel(String channel) {
        RedisMessageChannel[] values = values();
        for (int i = 0; i < values.length; i++) {
            if (values[i].getChannel().equals(channel)) {
                return values[i];
            }
        }
        return null;
    }
}
